[#-------------- ASSIGNMENTS --------------]
[#include "/mtk2/templates/includes/init.ftl"]

[#-- Image --]
[#-- Basic positioning of an image below or above the text --]
[#assign imagePosition = content.imagePosition!"below"]

[#-- CSS default --]
[#if !divClass?has_content]
    [#assign divClass = "text-section"]
[/#if]

[#-- Image css classes --]
[#assign imageHtml = ""]

[#if content.image?has_content]
    [#assign divClass = "${divClass} text-image-section"]
    [#assign imageClass = "content-image-${imagePosition}"]

    [#assign rendition = damfn.getRendition(content.image, "original")!]
    [#if rendition?has_content]
        [#include "/mtk2/templates/macros/image.ftl"]
        [#assign imageHtml][@image rendition content imageClass false def.parameters /][/#assign]
    [#elseif cmsfn.editMode]
        [#assign brokenMsg = i18n.get('image.no.src', [content.image]) /]
        [#assign alt = brokenMsg?has_content?then('alt=": ${brokenMsg}"', "")/]
        [#assign class = "broken-image ${imageClass}" /]
        [#assign src = "../dam/${content.image}"/]
        [#assign imageHtml]
            <div class="content-image-wrapper">
                <img ${alt} class="${class}" src="${src}"/>
            </div>
        [/#assign]
    [/#if]
[/#if]


[#-------------- RENDERING PART --------------]
[#-- Rendering: Text/Image item --]
<div class="${divClass!}"${divID!}>

    [#-- Headline --]
    [#if content.headline?has_content]
        <${headlineLevel}>${content.headline!}</${headlineLevel}>
    [/#if]

    [#-- Image above text --]
    [#if imageHtml?has_content && imagePosition == "above"]
        ${imageHtml}
    [/#if]

    [#-- Text --]
    [#if content.text?has_content]
        ${cmsfn.decode(content).text!}
    [/#if]

    [#-- Image below text --]
    [#if imageHtml?has_content && imagePosition == "below"]
        ${imageHtml}
    [/#if]

</div><!-- end ${divClass} -->
